TRANSLATED CONTENT:
# **开发经验与项目规范整理文档**

## 目录

1. 变量名维护方案
2. 文件结构与命名规范
3. 编码规范（Coding Style Guide）
4. 系统架构原则
5. 程序设计核心思想
6. 微服务
7. Redis
8. 消息队列

---

# **1. 变量名维护方案**

## 1.1 新建“变量名大全文件”

建立一个统一的变量索引文件，用于 AI 以及团队整体维护。

### 文件内容包括（格式示例）：

| 变量名      | 变量注释（描述） | 出现位置（文件路径）           | 出现频率（统计） |
| -------- | -------- | -------------------- | -------- |
| user_age | 用户年龄     | /src/user/profile.js | 12       |

### 目的

* 统一变量命名
* 方便全局搜索
* AI 或人工可统一管理、重构
* 降低命名冲突和语义不清晰带来的风险

---

# **2. 文件结构与命名规范**

## 2.1 子文件夹内容

每个子目录中需要包含：

* `agents` —— 负责自动化流程、提示词、代理逻辑
* `claude.md` —— 存放该文件夹内容的说明文档、设计思路与用途

## 2.2 文件命名规则

* 使用 **小写英文 + 下划线** 或 **小驼峰**（视语言而定）
* 文件名需体现内容职责
* 避免缩写与含糊不清的命名

示例：

* `user_service.js`
* `order_processor.py`
* `config_loader.go`

## 2.3 变量与定义规则及解释

* 命名尽可能语义化
* 遵循英语语法逻辑（名词属性、动词行为）
* 避免 `a, b, c` 此类无意义名称
* 常量使用大写 + 下划线（如：`MAX_RETRY_COUNT`）

---

# **3. 编码规范**

### 3.1 单一职责（Single Responsibility）

每个文件、每个类、每个函数应只负责一件事。

### 3.2 可复用函数 / 构建（Reusable Components）

* 提炼公共逻辑
* 避免重复代码（DRY）
* 模块化、函数化，提高复用价值

### 3.3 消费端 / 生产端 / 状态（变量）/ 变换（函数）

系统行为应明确划分：

| 概念     | 说明             |
| ------ | -------------- |
| 消费端    | 接收外部数据或依赖输入的地方 |
| 生产端    | 生成数据、输出结果的地方   |
| 状态（变量） | 存储当前系统信息的变量    |
| 变换（函数） | 处理状态、改变数据的逻辑   |

明确区分 **输入 → 处理 → 输出**，并独立管理每个环节。

### 3.4 并发（Concurrency）

* 清晰区分共享资源
* 避免数据竞争
* 必要时加锁或使用线程安全结构
* 区分“并发处理”和“异步处理”的差异

---

# **4. 系统架构原则**

### 4.1 先梳理清楚架构

在写代码前先明确：

* 模块划分
* 输入输出
* 数据流向
* 服务边界
* 技术栈
* 依赖关系

### 4.2 理解需求 → 保持简单 → 自动化测试 → 小步迭代

严谨开发流程：

1. 先理解需求
2. 保持架构与代码简单
3. 写可维护的自动化测试
4. 小步迭代，不做大爆炸开发

---

# **5. 程序设计核心思想**

## 5.1 从问题开始，而不是从代码开始

编程的第一步永远是：**你要解决什么问题？**

## 5.2 大问题拆小问题（Divide & Conquer）

复杂问题拆解为可独立完成的小单元。

## 5.3 KISS 原则（保持简单）

减少复杂度、魔法代码、晦涩技巧。

## 5.4 DRY 原则（不要重复）

用函数、类、模块复用逻辑，不要复制粘贴。

## 5.5 清晰的命名

* `user_age` 比 `a` 清晰
* `get_user_profile()` 比 `gp()` 清晰
  命名要体现**用途**和**语义**。

## 5.6 单一职责

一个函数只处理一个任务。

## 5.7 代码可读性优先

你写的代码是给别人理解的，不是来炫技的。

## 5.8 合理注释

注释解释“为什么”，不是“怎么做”。

## 5.9 Make it work → Make it right → Make it fast

先能跑，再让它好看，最后再优化性能。

## 5.10 错误是朋友，调试是必修课

阅读报错、查日志、逐层定位，是程序员核心技能。

## 5.11 Git 版本控制是必备技能

永远不要把代码只放本地。

## 5.12 测试你的代码

未测试的代码迟早会出问题。

## 5.13 编程是长期练习

所有人都经历过：

* bug 调不出来
* 通过时像挖到宝
* 看着看着能看懂别人代码

坚持即是高手。

---

# **6. 微服务**

微服务是一种架构模式，将系统拆解为多个 **独立开发、独立部署、独立扩容** 的服务。

特点：

* 每个服务处理一个业务边界（Bounded Context）
* 服务间通过 API 通信（HTTP、RPC、MQ 等）
* 更灵活、更可扩展、容错更高

---

# **7. Redis（缓存 / 内存数据库）**

Redis 的作用：

* 作为缓存极大提升系统“读性能”
* 降低数据库压力
* 提供计数、锁、队列、Session 等能力
* 让系统更快、更稳定、更抗压

---

# **8. 消息队列（Message Queue）**

消息队列用于服务之间的“异步通信”。

作用：

* 解耦
* 削峰填谷
* 异步任务处理
* 提高系统稳定性与吞吐
